<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Blog;

class CategoryController extends Controller
{

    public function index()
    {
        $categories = Category::all();
        return view( 'admin.blog.cat.index' , compact('categories'));
    }



    public function create1(){
        return view('admin.blog.cat.create1');
    }


    public function store(Request $request)
    {
        $request->validate([
            'cat' => 'required|string|max:255',
        ]);

        Category::create([
            'cat' => $request->cat,
        ]);

        return redirect()->route('admin.cat_index')->with('success', 'Category added successfully!');
    }

    public function edit($id)
    {
        $category = Category::findOrFail($id);

        return view('admin.blog.cat.edit', compact('category'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'cat' => 'required|string|max:255',
        ]);

        $category = Category::findOrFail($id);
        $category->update([
            'cat' => $request->cat,
        ]);

        return redirect()->route('admin.cat_index')->with('success', 'Category updated successfully!');
    }

    public function destroy($id)
    {
        // Find the category and delete it
        $category = Category::findOrFail($id);
        $category->delete();

        return redirect()->route('admin.cat_index')->with('success', 'Category deleted successfully!');
    }

    public function show($id)
    {
        $category = Category::findOrFail($id);
        $blogs = Blog::where('category_id', $category->id)->paginate(10);
        $latestPosts = Blog::latest()->take(4)->get(); // Fetch the latest posts
        $categories = Category::all(); // Fetch all categories
        return view('pages.blog.category', compact('category', 'blogs','latestPosts','categories'));
    }



    
}
