<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Blog;
use App\Models\Category;


class HomeController extends Controller
{
    public function index(){
        $blogs = Blog::with('category')->paginate(9); // Adjust pagination as needed
        return view('pages.index',compact('blogs'));
    }
    public function show($id)
{
    $blog = Blog::with('category')->findOrFail($id);
    $latestPosts = Blog::latest()->take(4)->get();
    $categories = Category::withCount('posts')->get();
    $relatedPosts = Blog::where('category_id', $blog->category_id)
                        ->where('id', '!=', $blog->id)
                        ->latest()
                        ->take(4)
                        ->get();
    
    // Find the next post
    $nextPost = Blog::where('id', '>', $blog->id)
                    ->orderBy('id')
                    ->first();
    
    // Find the previous post
    $previousPost = Blog::where('id', '<', $blog->id)
                        ->orderBy('id', 'desc')
                        ->first();

    $product_images = array_filter([
        $blog->product_image_1,
        $blog->product_image_2,
        $blog->product_image_3
    ]);

    return view('pages.blog.blog_details', compact('blog', 'latestPosts', 'categories', 'relatedPosts', 'nextPost', 'previousPost', 'product_images'));
}

    
    
    
}
