<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlogSection extends Model
{
    use HasFactory;

    protected $fillable = [
        'blog_id', 'subheading', 'long_image', 'small_images', 'long_text', 'buy_now'
    ];

    protected $casts = [
        'small_images' => 'array',
    ];

    public function blog()
    {
        return $this->belongsTo(Blog::class);
    }
}
