<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('author');
            $table->unsignedBigInteger('category_id');
            $table->string('tags')->nullable();
            $table->text('content');
            $table->string('image')->nullable();
            $table->timestamps();
        });

        Schema::create('blog_sections', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('blog_id');
            $table->string('subheading')->nullable();
            $table->string('long_image')->nullable();
            $table->json('small_images')->nullable();
            $table->text('long_text')->nullable();
            $table->string('buy_now')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('blog_sections');
        Schema::dropIfExists('blogs');
    }
};
