@extends('admin.layouts.master')

@section('backEndContent')
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.cat_create') }}">Blog</a></li>
                        <li class="breadcrumb-item">
                            <i class="feather-chevron-right"></i>
                        </li>
                        <li class="breadcrumb-item active">Add Blog Cat</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('admin.cat_store') }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Cat Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Category Name
                                            <span class="login-danger">*</span></label>
                                        <input class="form-control" name="cat" type="text" value="{{ old('cat') }}" />
                                        @error('cat')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <button type="submit" class="btn btn-primary">Add Now</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
