@extends('admin.layouts.master')

@section('backEndContent')
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href=" ">Blogs</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Blog</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('admin.update_blog', $blog->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('POST')
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Blog Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Blog Title</label>
                                        <input class="form-control" name="title" type="text" value="{{ $blog->title }}" required />
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Author Name</label>
                                        <input class="form-control" name="author" type="text" value="{{ $blog->author }}" required />
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Blog Category</label>
                                        <select name="category_id" class="form-control" required>
                                            <option>Choose Blog Category</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}" {{ $category->id == $blog->category_id ? 'selected' : '' }}>{{ $category->cat }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Tags <small>(separated with a comma)</small></label>
                                        <input name="tags" type="text" data-role="tagsinput" class="form-control" value="{{ $blog->tags }}" />
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-12">
                                    <div class="form-group summer-mail">
                                        <textarea id="summernote" name="content" rows="4" cols="5" class="form-control" placeholder="Enter your message here" required>{{ $blog->content }}</textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-12">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Blog Image</label>
                                        <div class="settings-btn upload-files-avator">
                                            <input type="file" name="image" accept="image/*" id="file" class="hide-input" />
                                            <label for="file" class="upload">Choose File</label>
                                            @if ($blog->image)
                                                <img src="{{ asset('storage/' . $blog->image) }}" alt="Current Image" style="max-width: 100px; margin-top: 10px;">
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Blog Sections</h4>
                                    </div>
                                </div>

                                <div id="dynamic-sections" class="col-12">
                                    @foreach ($blog->sections as $section)
                                    <div class="dynamic-section mb-4">
                                        <h5>Section</h5>
                                        <div class="mb-3">
                                            <label for="subheading" class="form-label">Subheading</label>
                                            <input type="text" name="subheading[]" class="form-control" value="{{ $section->subheading }}">
                                        </div>
                                        <div class="mb-3">
                                            <label for="long_image" class="form-label">Long Image</label>
                                            <input type="file" name="long_image[]" class="form-control">
                                            @if ($section->long_image)
                                                <img src="{{ asset('storage/' . $section->long_image) }}" alt="Current Image" style="max-width: 100px; margin-top: 10px;">
                                            @endif
                                        </div>
                                        <div class="mb-3">
                                            <label for="small_images" class="form-label">Small Images</label>
                                            <input type="file" name="small_images[]" class="form-control" multiple>
                                            @if ($section->small_images)
                                                @foreach (json_decode($section->small_images) as $small_image)
                                                    <img src="{{ asset('storage/' . $small_image) }}" alt="Current Image" style="max-width: 100px; margin-top: 10px;">
                                                @endforeach
                                            @endif
                                        </div>
                                        <div class="mb-3">
                                            <label for="long_text" class="form-label">Long Text</label>
                                            <textarea name="long_text[]" class="form-control">{{ $section->long_text }}</textarea>
                                        </div>
                                        <div class="mb-3">
                                            <label for="buy_now" class="form-label">Buy Now (Link)</label>
                                            <input type="text" name="buy_now[]" class="form-control" value="{{ $section->buy_now }}">
                                        </div>
                                        <button type="button" class="btn btn-danger remove-section">Remove Section</button>
                                    </div>
                                    @endforeach
                                </div>

                                <div class="col-12">
                                    <button type="button" class="btn btn-primary" id="add-section">Add Section</button>
                                </div>
                                
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Update Blog</button>
                                        <a href="" class="btn btn-secondary">Cancel</a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    function addRemoveSectionEvent(button) {
        button.addEventListener('click', function () {
            button.parentElement.remove();
        });
    }

    document.getElementById('add-section').addEventListener('click', function () {
        var section = document.querySelector('.dynamic-section').cloneNode(true);
        section.querySelectorAll('input, textarea').forEach(function (input) {
            input.value = '';
        });
        var removeButton = section.querySelector('.remove-section');
        addRemoveSectionEvent(removeButton);
        document.getElementById('dynamic-sections').appendChild(section);
    });

    document.querySelectorAll('.remove-section').forEach(function (button) {
        addRemoveSectionEvent(button);
    });
});
</script>
@endsection
