@extends('layouts.app')
@section('content')
<main class="main">
    <!-- Post Details Section -->
    <section class="mt-130 mb-30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-9 side-content">
                    <div class="theiaStickySidebar">
                        <!-- Post Single -->
                        <div class="post-single">
                            <div class="post-single__image">
                                <img src="{{ asset('storage/' . $blog->image) }}" alt="{{ $blog->title }}" class="post-single__image-img img-fluid">
                            </div>

                            <div class="post-single__content">
                                <a href="{{ url('category', $blog->category->id) }}" class="category">{{ $blog->category->cat }}</a> 
                                <h2 class="post-single__title">{{ $blog->title }}</h2>
                                <ul class="post-single__meta list-inline">
                                    <li class="post-single__meta-item">
                                        <a href="#" class="post-single__meta-link">Author:<span class="dot"></span> {{ $blog->author }}</a>
                                    </li>
                                    <li class="post-single__meta-item">
                                        <span class="dot"></span> {{ $blog->created_at->format('F d, Y') }}
                                    </li>
                                </ul>
                            </div>

                            <div class="post-single__body">
                                <p style="text-align: justify">{{ $blog->content }}</p>

                                <!-- Dynamic Sections -->
                                @if ($blog->sections)
                                    @foreach ($blog->sections as $section)
                                        <div class="section-block">
                                            @if ($section->subheading)
                                                <h5>{{ $section->subheading }}</h5>
                                            @endif
                                            @if ($section->long_image)
                                                <div class="block-image">
                                                    <img src="{{ asset('storage/' . $section->long_image) }}" alt="Section Image" class="block-image__img img-fluid">
                                                </div>
                                            @endif
                                            @if ($section->small_images)
                                                @foreach (json_decode($section->small_images) as $small_image)
                                                    <div class="block-image">
                                                        <img src="{{ asset('storage/' . $small_image) }}" alt="Small Image" class="block-image__img img-fluid">
                                                    </div>
                                                @endforeach
                                            @endif
                                            @if ($section->long_text)
                                                <p>{{ $section->long_text }}</p>
                                            @endif
                                            @if ($section->buy_now)
                                                <a href="{{ $section->buy_now }}" class="btn btn-primary">Buy Now</a>
                                            @endif
                                        </div>
                                    @endforeach
                                @endif
                            </div>

                            <div class="post-single__footer">
                                <ul class="list-inline widget__tags">
                                    @foreach (explode(',', $blog->tags) as $tag)
                                        <li class="widget__tags-item">
                                            <a href="#" class="widget__tags-link">{{ trim($tag) }}</a>
                                        </li>
                                    @endforeach
                                </ul>

                                <ul class="list-inline social-media social-media--layout-two">
                                    <li class="social-media__item">
                                        <a href="#" class="social-media__link color-facebook"><i class="bi bi-facebook"></i></a>
                                    </li>
                                    <li class="social-media__item">
                                        <a href="#" class="social-media__link color-instagram"><i class="bi bi-instagram"></i></a>
                                    </li>
                                    <li class="social-media__item">
                                        <a href="#" class="social-media__link color-twitter"><i class="bi bi-twitter-x"></i></a>
                                    </li>
                                    <li class="social-media__item">
                                        <a href="#" class="social-media__link color-youtube"><i class="bi bi-youtube"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <!-- Related Posts -->
                        <div class="row">
                            @foreach ($relatedPosts as $relatedPost)
                                <div class="col-md-6">
                                    <div class="widget">
                                        <div class="widget__related-post">
                                            <div class="widget__related-post__image">
                                                <a href="{{ route('post', $relatedPost->id) }}"> 
                                                    <img src="{{ asset('storage/' . $relatedPost->image) }}" alt="..." class="widget__related-post__img img-fluid">
                                                </a>
                                            </div>
                                            <div class="widget__related-post__content">
                                                <a class="btn-link" href="{{ route('post', $relatedPost->id) }}">
                                                    <i class="bi bi-arrow-left"></i>Preview post
                                                </a>
                                                <p class="widget__related-post__title">
                                                    <a href="{{ route('post', $relatedPost->id) }}" class="widget__related-post__link">{{ $relatedPost->title }}</a>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        
                            <div class="col-md-6">
                                <div class="widget">
                                    <div class="widget__related-post">
                                        <div class="widget__related-post__image">
                                            @if ($nextPost && $nextPost->image)
                                                <a href="{{ route('post', $nextPost->id) }}">
                                                    <img src="{{ asset('storage/' . $nextPost->image) }}" alt="Next Post Image" class="widget__related-post__img img-fluid">
                                                </a>
                                            @else
                                                <img src="{{ asset('storage/default.jpg') }}" alt="No Next Post" class="widget__related-post__img img-fluid">
                                            @endif
                                        </div>
                                        <div class="widget__related-post__content">
                                            @if ($nextPost)
                                                <a class="btn-link" href="{{ route('post', $nextPost->id) }}">
                                                    <i class="bi bi-arrow-right"></i>Next post
                                                </a>
                                                <p class="widget__related-post__title">
                                                    <a href="{{ route('post', $nextPost->id) }}" class="widget__related-post__link">{{ $nextPost->title }}</a>
                                                </p>
                                            @else
                                                <p class="widget__related-post__title">No Next Post Available</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="col-xl-3 max-width side-sidebar">
                    <div class="theiaStickySidebar">
                        @include('partials.sidebar')
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
@endsection
