@extends('layouts.app')
@section('content')
<main class="main">
    <!-- Banner -->
    <section class="banner">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-8">
                    <div class="banner__content">
                        <small class="banner__meta">
                            <a href="{{ route('index') }}" class="banner__link">Home</a>
                            <i class="bi bi-caret-right-fill banner__icon"></i>Shoes
                        </small>
                        <h3 class="banner__title">Category: <span class="banner__category-color">Shoes</span></h3>
                        <p class="banner__subtitle">Explore our latest blogs about shoes.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Blog Grid -->
    <section class="blog-classic">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-9 side-content">
                    <div class="theiaStickySidebar">
                        <div class="row">
                            <div class="col-lg-12 pl-45">
                                @foreach ($blogs as $blog)
                                <div class="post-card post-card--list mb-4">
                                    <div class="post-card__image">
                                        <a href="{{ route('post', $blog->id) }}">
                                            <img src="{{ asset('storage/' . $blog->image) }}" alt="{{ $blog->title }}">
                                        </a>
                                    </div>
                                    <div class="post-card__content">
                                        <a href="{{ route('category', $blog->category->id) }}" class="category">{{ $blog->category->cat }}</a>
                                        <h4 class="post-card__title">
                                            <a href="{{ route('post', $blog->id) }}" class="post-card__title-link">{{ $blog->title }}</a>
                                        </h4>
                                        <p class="post-card__exerpt">{{ Str::limit($blog->content, 100) }}</p>
                                        <ul class="post-card__meta list-inline">
                                            <li class="post-card__meta-item">
                                                <a href="#" class="post-card__meta-link">
                                                    <img src="{{ asset('storage/' . $blog->author_image) }}" alt="{{ $blog->author }}" class="post-card__meta-img">
                                                </a>
                                            </li>
                                            <li class="post-card__meta-item">
                                                <a href="#" class="post-card__meta-link">{{ $blog->author }}</a>
                                            </li>
                                            <li class="post-card__meta-item">
                                                <span class="dot"></span> {{ $blog->created_at->format('F d, Y') }}
                                            </li>
                                            <li class="post-card__meta-item"><span class="dot"></span> <button class="btn btn-primary">Buy Now!</button></li>
                                        </ul>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        <!-- Pagination -->
                        <div class="row">
                            <div class="col-lg-12">
                                {{ $blogs->links() }}
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="col-xl-3 max-width side-sidebar">
                    <div class="theiaStickySidebar">
                        @include('partials.sidebar')
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section class="newslettre__section">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-md-10 col-sm-11 m-auto">
                    <div class="newslettre">
                        <div class="newslettre__info">
                            <h3 class="newslettre__title">Get The Best Blog Stories into Your inbox!</h3>
                            <p class="newslettre__desc">Sign up for free and be the first to get notified about new posts.</p>
                        </div>
                        <form action="#" class="newslettre__form">
                            <input type="email" class="newslettre__form-input form-control" placeholder="Your email address" required>
                            <button type="submit" class="newslettre__form-submit">Subscribe</button>
                        </form>
                        <ul class="list-inline social-media social-media--layout-three">
                            <li class="social-media__item">
                                <a href="#" class="social-media__link"><i class="bi bi-facebook"></i>Facebook</a>
                            </li>
                            <li class="social-media__item">
                                <a href="#" class="social-media__link"><i class="bi bi-instagram"></i>Instagram</a>
                            </li>
                            <li class="social-media__item">
                                <a href="#" class="social-media__link"><i class="bi bi-twitter-x"></i>Twitter</a>
                            </li>
                            <li class="social-media__item">
                                <a href="#" class="social-media__link"><i class="bi bi-youtube"></i>Youtube</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
@endsection
