<!-- widget-author -->
<div class="widget">
    <div class="widget__author">
        <div class="widget__author-top">
            <a href="author.html" class="widget__author-link">
                <img src="{{asset('assets/img/author/1.jpg')}}" alt="" class="widget__author-img">
            </a>
        </div>
        <div class="widget__author-content">
            <h6 class="widget__author-name"> Hi, I'm Kush</h6>
            <p class="widget__author-bio">
                Hello! I'm Kush, a passionate blogger with a love for all things footwear. Welcome to my corner of the internet where I share my insights, reviews, and latest trends in the world of shoes.            </p>
            <ul class="list-inline social-media social-media--layout-two">
                <li class="social-media__item">
                    <a href="#" class="social-media__link color-facebook"><i class="bi bi-facebook"></i></a>
                </li>
                <li class="social-media__item">
                    <a href="#" class="social-media__link color-instagram"><i class="bi bi-instagram"></i></a>
                </li>
                <li class="social-media__item">
                    <a href="#" class="social-media__link color-twitter"><i class="bi bi-twitter-x"></i></a>
                </li>
                <li class="social-media__item">
                    <a href="#" class="social-media__link color-youtube"><i class="bi bi-youtube"></i></a>
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- widget-Latest-Posts -->
<div class="widget">
    <h5 class="widget__title">Latest Posts</h5>
    <ul class="widget__latest-posts">
        @foreach ($latestPosts as $post)
        <li class="widget__latest-posts__item">
            <div class="widget__latest-posts-image">
                <a href="{{ route('post', $post->id) }}" class="widget__latest-posts-link"> 
                    <img src="{{ asset('storage/' . $post->image) }}" alt="..." class="widget__latest-posts-img">
                </a>
            </div>
            <div class="widget__latest-posts-count">{{ $loop->iteration }}</div>
            <div class="widget__latest-posts__content">
                <p class="widget__latest-posts-title">
                    <a href="{{ route('post', $post->id) }}" class="widget__latest-posts-link">{{ $post->title }}</a>
                </p>
                <small class="widget__latest-posts-date">
                    <i class="bi bi-clock-fill widget__latest-posts-icon"></i>{{ $post->created_at->format('F d, Y') }}
                </small>
            </div>
        </li>
        @endforeach
    </ul>
</div>

<!-- widget-categories -->
<div class="widget">
    <h5 class="widget__title">Categories</h5>
    <ul class="widget__categories">
        @foreach ($categories as $category)
        <li class="widget__categories-item">
            <a href="{{ url('category', $category->id) }}" class="category widget__categories-link">{{ $category->cat }}</a>
            <span class="ml-auto widget__categories-number">{{ $category->posts_count }} Posts</span>
        </li>
        @endforeach
    </ul>
</div>

 

<!-- widget-tags -->
<div class="widget">
    <h5 class="widget__title">Tags</h5>
    <ul class="list-inline widget__tags">
        @foreach (explode(',', $blog->tags) as $tag)
        <li class="widget__tags-item">
            <a href="#" class="widget__tags-link">{{ trim($tag) }}</a>
        </li>
        @endforeach
    </ul>
</div>

<!-- widget-ads -->
<div class="widget">
    <h5 class="widget__title">Ads</h5>
    <div class="widget__ads">
        <a href="#" class="widget__ads-link">
            <img src="{{ asset('assets/img/ads/ads3.jpg') }}" alt="" class="widget__ads-img">
        </a>
    </div>
</div>
