<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\CategoryController;




Route::get('',[HomeController::class ,'index'])->name('index');
Route::get('/post/{id}', [HomeController::class, 'show'])->name('post');

 
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login.show');
Route::post('/login', [AuthController::class, 'login'])->name('login');
Route::get('/categories/{id}', [CategoryController::class, 'show'])->name('category');

Route::get('/shoes', [BlogController::class, 'shoes'])->name('shoes');

Route::get('/blogs', [BlogController::class, 'allBlogs'])->name('all_blogs');




Route::middleware(['auth', 'admin'])->group(function () {
    Route::get('/admin/dashboard', [AdminController::class, 'index'])->name('admin.dashboard');

   // Category Routes
   Route::get('categor/create1', [CategoryController::class, 'create1'])->name('admin.cat_create');
   Route::post('category/store', [CategoryController::class, 'store'])->name('admin.cat_store');
   Route::get('category', [CategoryController::class, 'index'])->name('admin.cat_index');
   Route::get('category/{id}/edit', [CategoryController::class, 'edit'])->name('admin.cat_edit');
   Route::put('category/{id}', [CategoryController::class, 'update'])->name('admin.cat_update');
   Route::delete('category/{id}', [CategoryController::class, 'destroy'])->name('admin.cat_destroy');
   Route::get('category/{id}', [CategoryController::class, 'show'])->name('admin.cat_show');

    Route::get('/admin/create_blog', [BlogController::class, 'create'])->name('admin.create_blog');
    Route::post('/admin/store_blog', [BlogController::class, 'store'])->name('admin.store_blog');
    Route::get('/admin/edit_blog/{id}', [BlogController::class, 'edit'])->name('admin.edit_blog');
    Route::post('/admin/update_blog/{id}', [BlogController::class, 'update'])->name('admin.update_blog');
    Route::delete('/admin/delete_blog/{id}', [BlogController::class, 'destroy'])->name('admin.delete_blog');
    Route::get('/admin/blogs', [BlogController::class, 'index'])->name('admin.index_blog');

 });