
<?php $__env->startSection('content'); ?>
<main class="main">
    <!-- Post Details Section -->
    <section class="mt-130 mb-30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-9 side-content">
                    <div class="theiaStickySidebar">
                        <!-- Post Single -->
                        <div class="post-single">
                            <div class="post-single__image">
                                <img src="<?php echo e(asset('storage/' . $blog->image)); ?>" alt="<?php echo e($blog->title); ?>" class="post-single__image-img img-fluid">
                            </div>

                            <div class="post-single__content">
                                <a href="<?php echo e(url('category', $blog->category->id)); ?>" class="category"><?php echo e($blog->category->cat); ?></a> 
                                <h2 class="post-single__title"><?php echo e($blog->title); ?></h2>
                                <ul class="post-single__meta list-inline">
                                    <li class="post-single__meta-item">
                                        <a href="#" class="post-single__meta-link">Author:<span class="dot"></span> <?php echo e($blog->author); ?></a>
                                    </li>
                                    <li class="post-single__meta-item">
                                        <span class="dot"></span> <?php echo e($blog->created_at->format('F d, Y')); ?>

                                    </li>
                                </ul>
                            </div>

                            <div class="post-single__body">
                                <p style="text-align: justify"><?php echo e($blog->content); ?></p>

                                <!-- Dynamic Sections -->
                                <?php if($blog->sections): ?>
                                    <?php $__currentLoopData = $blog->sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="section-block">
                                            <?php if($section->subheading): ?>
                                                <h5><?php echo e($section->subheading); ?></h5>
                                            <?php endif; ?>
                                            <?php if($section->long_image): ?>
                                                <div class="block-image">
                                                    <img src="<?php echo e(asset('storage/' . $section->long_image)); ?>" alt="Section Image" class="block-image__img img-fluid">
                                                </div>
                                            <?php endif; ?>
                                            <?php if($section->small_images): ?>
                                                <?php $__currentLoopData = json_decode($section->small_images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $small_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="block-image">
                                                        <img src="<?php echo e(asset('storage/' . $small_image)); ?>" alt="Small Image" class="block-image__img img-fluid">
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                            <?php if($section->long_text): ?>
                                                <p><?php echo e($section->long_text); ?></p>
                                            <?php endif; ?>
                                            <?php if($section->buy_now): ?>
                                                <a href="<?php echo e($section->buy_now); ?>" class="btn btn-primary">Buy Now</a>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>

                            <div class="post-single__footer">
                                <ul class="list-inline widget__tags">
                                    <?php $__currentLoopData = explode(',', $blog->tags); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="widget__tags-item">
                                            <a href="#" class="widget__tags-link"><?php echo e(trim($tag)); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>

                                <ul class="list-inline social-media social-media--layout-two">
                                    <li class="social-media__item">
                                        <a href="#" class="social-media__link color-facebook"><i class="bi bi-facebook"></i></a>
                                    </li>
                                    <li class="social-media__item">
                                        <a href="#" class="social-media__link color-instagram"><i class="bi bi-instagram"></i></a>
                                    </li>
                                    <li class="social-media__item">
                                        <a href="#" class="social-media__link color-twitter"><i class="bi bi-twitter-x"></i></a>
                                    </li>
                                    <li class="social-media__item">
                                        <a href="#" class="social-media__link color-youtube"><i class="bi bi-youtube"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <!-- Related Posts -->
                        <div class="row">
                            <?php $__currentLoopData = $relatedPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedPost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6">
                                    <div class="widget">
                                        <div class="widget__related-post">
                                            <div class="widget__related-post__image">
                                                <a href="<?php echo e(route('post', $relatedPost->id)); ?>"> 
                                                    <img src="<?php echo e(asset('storage/' . $relatedPost->image)); ?>" alt="..." class="widget__related-post__img img-fluid">
                                                </a>
                                            </div>
                                            <div class="widget__related-post__content">
                                                <a class="btn-link" href="<?php echo e(route('post', $relatedPost->id)); ?>">
                                                    <i class="bi bi-arrow-left"></i>Preview post
                                                </a>
                                                <p class="widget__related-post__title">
                                                    <a href="<?php echo e(route('post', $relatedPost->id)); ?>" class="widget__related-post__link"><?php echo e($relatedPost->title); ?></a>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                            <div class="col-md-6">
                                <div class="widget">
                                    <div class="widget__related-post">
                                        <div class="widget__related-post__image">
                                            <?php if($nextPost && $nextPost->image): ?>
                                                <a href="<?php echo e(route('post', $nextPost->id)); ?>">
                                                    <img src="<?php echo e(asset('storage/' . $nextPost->image)); ?>" alt="Next Post Image" class="widget__related-post__img img-fluid">
                                                </a>
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('storage/default.jpg')); ?>" alt="No Next Post" class="widget__related-post__img img-fluid">
                                            <?php endif; ?>
                                        </div>
                                        <div class="widget__related-post__content">
                                            <?php if($nextPost): ?>
                                                <a class="btn-link" href="<?php echo e(route('post', $nextPost->id)); ?>">
                                                    <i class="bi bi-arrow-right"></i>Next post
                                                </a>
                                                <p class="widget__related-post__title">
                                                    <a href="<?php echo e(route('post', $nextPost->id)); ?>" class="widget__related-post__link"><?php echo e($nextPost->title); ?></a>
                                                </p>
                                            <?php else: ?>
                                                <p class="widget__related-post__title">No Next Post Available</p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="col-xl-3 max-width side-sidebar">
                    <div class="theiaStickySidebar">
                        <?php echo $__env->make('partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\kush\kushBlogs\resources\views/pages/blog/blog_details.blade.php ENDPATH**/ ?>