

<?php $__env->startSection('backEndContent'); ?>
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href=" ">Blogs</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Blog</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.update_blog', $blog->id)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('POST'); ?>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Blog Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Blog Title</label>
                                        <input class="form-control" name="title" type="text" value="<?php echo e($blog->title); ?>" required />
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Author Name</label>
                                        <input class="form-control" name="author" type="text" value="<?php echo e($blog->author); ?>" required />
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Blog Category</label>
                                        <select name="category_id" class="form-control" required>
                                            <option>Choose Blog Category</option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>" <?php echo e($category->id == $blog->category_id ? 'selected' : ''); ?>><?php echo e($category->cat); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Tags <small>(separated with a comma)</small></label>
                                        <input name="tags" type="text" data-role="tagsinput" class="form-control" value="<?php echo e($blog->tags); ?>" />
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-12">
                                    <div class="form-group summer-mail">
                                        <textarea id="summernote" name="content" rows="4" cols="5" class="form-control" placeholder="Enter your message here" required><?php echo e($blog->content); ?></textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-12">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Blog Image</label>
                                        <div class="settings-btn upload-files-avator">
                                            <input type="file" name="image" accept="image/*" id="file" class="hide-input" />
                                            <label for="file" class="upload">Choose File</label>
                                            <?php if($blog->image): ?>
                                                <img src="<?php echo e(asset('storage/' . $blog->image)); ?>" alt="Current Image" style="max-width: 100px; margin-top: 10px;">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Blog Sections</h4>
                                    </div>
                                </div>

                                <div id="dynamic-sections" class="col-12">
                                    <?php $__currentLoopData = $blog->sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="dynamic-section mb-4">
                                        <h5>Section</h5>
                                        <div class="mb-3">
                                            <label for="subheading" class="form-label">Subheading</label>
                                            <input type="text" name="subheading[]" class="form-control" value="<?php echo e($section->subheading); ?>">
                                        </div>
                                        <div class="mb-3">
                                            <label for="long_image" class="form-label">Long Image</label>
                                            <input type="file" name="long_image[]" class="form-control">
                                            <?php if($section->long_image): ?>
                                                <img src="<?php echo e(asset('storage/' . $section->long_image)); ?>" alt="Current Image" style="max-width: 100px; margin-top: 10px;">
                                            <?php endif; ?>
                                        </div>
                                        <div class="mb-3">
                                            <label for="small_images" class="form-label">Small Images</label>
                                            <input type="file" name="small_images[]" class="form-control" multiple>
                                            <?php if($section->small_images): ?>
                                                <?php $__currentLoopData = json_decode($section->small_images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $small_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <img src="<?php echo e(asset('storage/' . $small_image)); ?>" alt="Current Image" style="max-width: 100px; margin-top: 10px;">
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="mb-3">
                                            <label for="long_text" class="form-label">Long Text</label>
                                            <textarea name="long_text[]" class="form-control"><?php echo e($section->long_text); ?></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <label for="buy_now" class="form-label">Buy Now (Link)</label>
                                            <input type="text" name="buy_now[]" class="form-control" value="<?php echo e($section->buy_now); ?>">
                                        </div>
                                        <button type="button" class="btn btn-danger remove-section">Remove Section</button>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <div class="col-12">
                                    <button type="button" class="btn btn-primary" id="add-section">Add Section</button>
                                </div>
                                
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Update Blog</button>
                                        <a href="" class="btn btn-secondary">Cancel</a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    function addRemoveSectionEvent(button) {
        button.addEventListener('click', function () {
            button.parentElement.remove();
        });
    }

    document.getElementById('add-section').addEventListener('click', function () {
        var section = document.querySelector('.dynamic-section').cloneNode(true);
        section.querySelectorAll('input, textarea').forEach(function (input) {
            input.value = '';
        });
        var removeButton = section.querySelector('.remove-section');
        addRemoveSectionEvent(removeButton);
        document.getElementById('dynamic-sections').appendChild(section);
    });

    document.querySelectorAll('.remove-section').forEach(function (button) {
        addRemoveSectionEvent(button);
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\kush\kushBlogs\resources\views/admin/blog/edit.blade.php ENDPATH**/ ?>