
<?php $__env->startSection('content'); ?>
<main class="main">
    <!-- Carousel Section -->
    <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel">
        <div class="carousel-indicators">
            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="1" aria-label="Slide 2"></button>
            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="2" aria-label="Slide 3"></button>
        </div>
        <div class="carousel-inner">
            <div class="carousel-item active">
                <img src="<?php echo e(asset('assets/img/blog/s6.jpg')); ?>" class="d-block w-100" alt="...">
                <div class="carousel-caption">
                    <h5>Best White Sneakers You Gotta Have</h5>
                    <p>In the ever-evolving world of fashion, one trend remains timeless and essential: the white sneaker.</p>
                    <div class="btn-container">
                        <button class="btn btn-primary">Learn More!</button>
                    </div>
                </div>
            </div>
            <div class="carousel-item">
                <img src="<?php echo e(asset('assets/img/blog/s3.jpg')); ?>" class="d-block w-100" alt="...">
                <div class="carousel-caption">
                    <h5>Revamp Your Wardrobe with the 10 best Creative Recreation Shoes</h5>
                    <p>Explore the dynamic world of sneakers with our comprehensive guide, designed for enthusiasts and casual wearers alike.</p>
                    <div class="btn-container">
                        <button class="btn btn-primary">Discover</button>
                    </div>
                </div>
            </div>
            <div class="carousel-item">
                <img src="<?php echo e(asset('assets/img/blog/s5.jpg')); ?>" class="d-block w-100" alt="...">
                <div class="carousel-caption">
                    <h5>Discover the Latest Sneaker Trends</h5>
                    <p>Welcome to our sneaker haven, where style meets comfort and innovation. Our website is your go-to destination for the freshest and trendiest sneakers on the market.</p>
                    <div class="btn-container">
                        <button class="btn btn-primary">Read More</button>
                    </div>
                </div>
            </div>
        </div>
        <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Previous</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Next</span>
        </button>
    </div>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="hero-content">
            <h1>Discover the Latest in <span id="animated-text"></span> at Kush Blog</h1>
            <p>Your go-to destination for all things sneakers, clothing, and more.</p>
            <a href="#latest-posts" class="btn btn-primary">Explore Now</a>
        </div>
    </section>
    <div class="mouse-effect">
        <div class="mouse-point"></div>
    </div>

    <!-- Blog Section -->
    <section class="mt-90">
        <div class="container-fluid">
            <div class="row">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <!-- Dynamic Post -->
                <div class="col-xl-4 col-lg-6 col-md-6" data-aos="<?php echo e($index % 2 == 0 ? 'fade-right' : 'fade-left'); ?>" data-aos-delay="100">
                    <div class="post-card post-card--default">
                        <div class="post-card__image">
                            <a href="<?php echo e(route('post', $blog->id)); ?>">
                                <img src="<?php echo e(asset('storage/' . $blog->image)); ?>" alt="<?php echo e($blog->title); ?>">
                            </a>
                        </div>
    
                        <div class="post-card__content">
                            <a href="<?php echo e(url('category', $blog->category->id)); ?>" class="category"><?php echo e($blog->category->cat); ?></a>
                            <h5 class="post-card__title">
                                <a href="<?php echo e(route('post', $blog->id)); ?>" class="post-card__title-link"><?php echo e($blog->title); ?></a>
                            </h5>
                            <p class="post-card__exerpt"><?php echo e(Str::limit($blog->content, 100)); ?></p>
    
                            <ul class="post-card__meta list-inline">
                                <li class="post-card__meta-item">
                                    <a href="#" class="post-card__meta-link"><?php echo e($blog->author); ?></a>
                                </li>
                                <li class="post-card__meta-item">
                                    <span class="dot"></span> <?php echo e($blog->created_at->format('F d, Y')); ?>

                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
    
            <!-- Pagination -->
            <div class="row">
                <div class="col-lg-12">
                    <?php echo e($blogs->links()); ?>

                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="testimonial-section" data-aos="fade-up">
        <div class="container">
            <h2 class="section-title">What Our Readers Say</h2>
            <div class="testimonial-container">
                <div class="testimonial-card" data-aos="fade-right">
                    <p>"This blog has completely transformed my sneaker game. I love the reviews and tips!"</p>
                    <h4>- Alex Johnson</h4>
                </div>
                <div class="testimonial-card" data-aos="fade-left">
                    <p>"A must-read for any sneaker enthusiast. The latest releases section is my favorite."</p>
                    <h4>- Maria Smith</h4>
                </div>
                <div class="testimonial-card" data-aos="fade-right">
                    <p>"The style guides are so helpful! I've learned so much about matching my outfits."</p>
                    <h4>- John Doe</h4>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section class="newsletter-section" data-aos="fade-up">
        <div class="floating-circle circle-middle-left"></div>
        <div class="floating-circle circle-middle-right"></div>
        <div class="container">
            <div class="newsletter-content">
                <h3>Stay Updated with Our Latest Posts</h3>
                <p>Subscribe to our newsletter and never miss an update!</p>
                <form action="#" class="newsletter-form">
                    <input type="email" class="form-control" placeholder="Enter your email" required>
                    <button type="submit" class="btn btn-primary">Subscribe</button>
                </form>
            </div>
        </div>
    </section>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\kush\kushBlogs\resources\views/pages/index.blade.php ENDPATH**/ ?>